% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TvCstd.m
function [beta_std, gamma_std, Nm_std, Sa_std] = TvCstd(TvC0)  

data = TvC0;
NperformanceLevels = (size(TvC0, 1) -1)/2;
NnoiseLevels = size(TvC0, 2) - 1;
beta0 = []; gamma0 = []; Nm0=[]; Sa0=[];

for n = 1 : 1000
    TvC = TvC0(1, :);
   for i = 1 : NperformanceLevels
       TvC = [TvC; TvC0((i+1), 1) ...
         TvC0((i+1), 2:(NnoiseLevels+1)) + ...
         TvC0((NperformanceLevels+i+1), 2:(NnoiseLevels+1)) ...
         .*randn(1, NnoiseLevels)];
   end
   [beta, gamma, Nm, Sa, r2] = fittingTvC(TvC); 
  
   beta0 = [beta0; beta];
   gamma0 = [gamma0; gamma];
   Nm0 = [Nm0; Nm];
   Sa0 = [Sa0; Sa];
end
beta_std = std(beta0);
gamma_std = std(gamma0);
Nm_std = std(Nm0);
Sa_std = std(Sa0);
